/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.configuration;

import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.searchguard.configuration.CType;
import com.floragunn.searchguard.configuration.ConfigMap;
import com.floragunn.searchguard.configuration.ConfigUnavailableException;
import com.floragunn.searchguard.configuration.ConfigurationRepository;
import com.floragunn.searchguard.configuration.NoSuchConfigEntryException;
import com.floragunn.searchguard.configuration.SgConfigEntry;
import com.floragunn.searchguard.configuration.SgDynamicConfiguration;
import com.floragunn.searchguard.configuration.StaticSgConfig;
import com.floragunn.searchguard.support.PrivilegedConfigClient;
import com.floragunn.searchsupport.cstate.ComponentState;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.get.MultiGetItemResponse;
import org.elasticsearch.action.get.MultiGetRequest;
import org.elasticsearch.action.get.MultiGetResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentType;

public class ConfigurationLoader {
    private static final Logger log = LogManager.getLogger(ConfigurationLoader.class);
    private final PrivilegedConfigClient client;
    private final Map<CType<?>, ComponentState> typeToStateMap;
    private final ConfigurationRepository configRepository;
    private final StaticSgConfig staticSgConfig;

    public ConfigurationLoader(Client client, ConfigurationRepository configRepository) {
        this(client, null, configRepository, null);
    }

    public ConfigurationLoader(Client client, ComponentState componentState, ConfigurationRepository configRepository, StaticSgConfig staticSgConfig) {
        this.client = PrivilegedConfigClient.adapt(client);
        this.configRepository = configRepository;
        this.staticSgConfig = staticSgConfig;
        if (componentState != null) {
            this.typeToStateMap = new HashMap(CType.all().size());
            for (CType<?> ctype : CType.all()) {
                this.typeToStateMap.put(ctype, componentState.getOrCreatePart("config_type", ctype.toLCString()).mandatory(!ctype.isOptional()));
            }
        } else {
            this.typeToStateMap = null;
        }
    }

    public <T> SgDynamicConfiguration<T> loadSync(CType<T> type, String reason, ConfigurationRepository.Context context) throws ConfigUnavailableException {
        try {
            return this.load(type, reason, context).get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof ConfigUnavailableException) {
                throw (ConfigUnavailableException)e.getCause();
            }
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            if (e.getCause() instanceof Error) {
                throw (Error)e.getCause();
            }
            throw new RuntimeException(e);
        }
    }

    public ConfigMap loadSync(Set<CType<?>> types, String reason, ConfigurationRepository.Context context) throws ConfigUnavailableException {
        try {
            return this.load(types, reason, context).get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof ConfigUnavailableException) {
                throw (ConfigUnavailableException)e.getCause();
            }
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            if (e.getCause() instanceof Error) {
                throw (Error)e.getCause();
            }
            throw new RuntimeException(e);
        }
    }

    public <T> SgConfigEntry<T> loadEntrySync(CType<T> configType, String id, String reason, ConfigurationRepository.Context context) throws ConfigUnavailableException, NoSuchConfigEntryException {
        SgDynamicConfiguration<T> baseConfig = this.loadSync(configType, reason, context);
        T entry = baseConfig.getCEntry(id);
        if (entry != null) {
            return new SgConfigEntry<T>(entry, baseConfig);
        }
        throw new NoSuchConfigEntryException(configType, id);
    }

    public <T> CompletableFuture<SgDynamicConfiguration<T>> load(CType<T> type, String reason, ConfigurationRepository.Context context) {
        return this.load(Collections.singleton(type), reason, context).thenApply(configMap -> configMap.get(type));
    }

    public CompletableFuture<ConfigMap> load(Set<CType<?>> types, final String reason, final ConfigurationRepository.Context context) {
        final CompletableFuture<ConfigMap> resultFuture = new CompletableFuture<ConfigMap>();
        final String searchguardIndex = this.configRepository.getEffectiveSearchGuardIndex();
        if (searchguardIndex == null) {
            resultFuture.completeExceptionally(new ConfigUnavailableException("Search Guard index does not exist"));
            return resultFuture;
        }
        MultiGetRequest mget = new MultiGetRequest().refresh(true).realtime(true);
        final HashSet expectedTypes = new HashSet();
        for (CType<?> cType : types) {
            if (cType.isExternal()) continue;
            mget.add(searchguardIndex, cType.toLCString());
            if (cType.isOptional()) continue;
            expectedTypes.add(cType);
        }
        if (log.isTraceEnabled()) {
            log.trace("Issuing " + mget);
        }
        this.client.multiGet(mget, (ActionListener)new ActionListener<MultiGetResponse>(){

            public void onResponse(MultiGetResponse response) {
                try {
                    if (log.isDebugEnabled()) {
                        log.debug("Response: " + Arrays.asList(response.getResponses()).stream().map(r -> r.getId() + ": failure: " + r.getFailure() + "; exists: " + r.getResponse().isExists() + "; sourceEmpty: " + r.getResponse().isSourceEmpty() + "; version: " + r.getResponse().getVersion() + "; seqno: " + r.getResponse().getSeqNo() + "; pt: " + r.getResponse().getPrimaryTerm() + "; size: " + (r.getResponse().getSourceAsBytes() != null ? Integer.valueOf(r.getResponse().getSourceAsBytes().length) : "null")).collect(Collectors.toList()));
                    }
                    ArrayList<MultiGetResponse.Failure> failures = new ArrayList<MultiGetResponse.Failure>();
                    ConfigMap.Builder configMapBuilder = new ConfigMap.Builder(searchguardIndex);
                    for (MultiGetItemResponse item : response.getResponses()) {
                        MultiGetResponse.Failure failure;
                        CType<?> type;
                        CType<?> cType = type = item.getId() != null ? CType.fromString(item.getId()) : null;
                        if (item.isFailed()) {
                            failures.add(item.getFailure());
                            ConfigurationLoader.this.failure(type, item.getFailure(), ConfigurationLoader.this.typeToStateMap);
                            continue;
                        }
                        try {
                            SgDynamicConfiguration config = ConfigurationLoader.this.toConfig(type, item.getResponse(), context);
                            if (ConfigurationLoader.this.staticSgConfig != null) {
                                config = ConfigurationLoader.this.staticSgConfig.addTo(config);
                            }
                            configMapBuilder.with(config);
                            ConfigurationLoader.this.success(config, ConfigurationLoader.this.typeToStateMap);
                        }
                        catch (ConfigValidationException e) {
                            failure = new MultiGetResponse.Failure(searchguardIndex, item.getResponse().getType(), item.getResponse().getId(), new Exception(e.getValidationErrors().toString(), e));
                            failures.add(failure);
                            ConfigurationLoader.this.failure(type, failure, ConfigurationLoader.this.typeToStateMap);
                        }
                        catch (Exception e) {
                            failure = new MultiGetResponse.Failure(searchguardIndex, item.getResponse().getType(), item.getResponse().getId(), e);
                            failures.add(failure);
                            ConfigurationLoader.this.failure(type, failure, ConfigurationLoader.this.typeToStateMap);
                        }
                    }
                    ConfigMap result = configMapBuilder.build();
                    if (!result.containsAll(expectedTypes)) {
                        throw new ConfigUnavailableException("Error while loading configuration (for " + reason + "):\n" + failures.stream().map(f -> Strings.toString((ToXContent)f)).collect(Collectors.toList()), !failures.isEmpty() ? ((MultiGetResponse.Failure)failures.get(0)).getFailure() : null);
                    }
                    resultFuture.complete(result);
                }
                catch (ConfigUnavailableException e) {
                    log.warn("Error while loading config", (Throwable)e);
                    resultFuture.completeExceptionally(e);
                }
                catch (Throwable e) {
                    log.error("Error while loading config", e);
                    resultFuture.completeExceptionally(e);
                }
            }

            public void onFailure(Exception e) {
                log.error("Error while loading config", (Throwable)e);
                resultFuture.completeExceptionally(e);
            }
        });
        return resultFuture;
    }

    private SgDynamicConfiguration<?> toConfig(CType<?> type, GetResponse getResponse, ConfigurationRepository.Context context) throws Exception {
        if (!getResponse.isExists()) {
            if (type != null && type.isOptional()) {
                SgDynamicConfiguration<?> result = SgDynamicConfiguration.empty(type);
                result.getComponentState().setState(ComponentState.State.SUSPENDED, "config_does_not_exist");
                return result;
            }
            throw new Exception("Document does not exist");
        }
        if (getResponse.isSourceEmpty()) {
            throw new Exception("Document source is empty");
        }
        BytesReference source = getResponse.getSourceAsBytesRef();
        String id = getResponse.getId();
        try (XContentParser parser = XContentHelper.createParser((NamedXContentRegistry)NamedXContentRegistry.EMPTY, (DeprecationHandler)DeprecationHandler.THROW_UNSUPPORTED_OPERATION, (BytesReference)source, (XContentType)XContentType.JSON);){
            parser.nextToken();
            parser.nextToken();
            if (!id.equals(parser.currentName())) {
                throw new Exception("Invalid config index: " + id + " vs " + parser.currentName());
            }
            parser.nextToken();
            SgDynamicConfiguration sgDynamicConfiguration = (SgDynamicConfiguration)SgDynamicConfiguration.fromJson(new String(parser.binaryValue()), type, getResponse.getVersion(), getResponse.getSeqNo(), getResponse.getPrimaryTerm(), context).peek();
            return sgDynamicConfiguration;
        }
    }

    private void success(SgDynamicConfiguration<?> config, Map<CType<?>, ComponentState> typeToStateMap) {
        if (typeToStateMap == null) {
            return;
        }
        ComponentState configState = typeToStateMap.get(config.getCType());
        if (configState != null) {
            configState.replacePart(config.getComponentState());
            configState.updateStateFromParts();
        }
    }

    private void failure(CType<?> type, MultiGetResponse.Failure failure, Map<CType<?>, ComponentState> typeToStateMap) {
        if (type == null || typeToStateMap == null) {
            return;
        }
        ComponentState configState = typeToStateMap.get(type);
        if (configState != null) {
            configState.setFailed(failure.getMessage());
            configState.setDetailJson(Strings.toString((ToXContent)failure));
        }
    }
}

